#!/bin/sh
# usage is create_group.sh user grp
if ! getent group | grep --quiet "^$2:" ; then
    echo -n "Adding group $2.."
    addgroup --quiet --system $2 2>/dev/null ||true
    echo "..done"
fi

if ! getent passwd | grep --quiet "^$1:"; then
	echo -n "Adding system user $1.."
	adduser --quiet \
			--system \
			--ingroup $2 \
			--no-create-home \
			--disabled-password \
			$1 2>/dev/null || true
	echo "..done"
fi
